<?php

namespace App\Notifications;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachApproved extends Notification implements ShouldQueue
{
    use Queueable;

    public function via(object $notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('¡Tu cuenta ha sido aprobada!')
            ->greeting('¡Bienvenido a CoachPro, ' . $notifiable->name . '!')
            ->line('Tu cuenta de entrenador ha sido aprobada por nuestro equipo.')
            ->line('Ya puedes comenzar a agregar clientes, crear rutinas y planes de alimentación.')
            ->action('Comenzar Ahora', url('/dashboard'))
            ->line('¡Éxito en tu carrera como coach!');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'coach_approved',
            'message' => '🎉 Tu cuenta ha sido aprobada. ¡Bienvenido a CoachPro!',
            'title' => 'Cuenta aprobada',
            'url' => route('coach.dashboard'),
        ];
    }
}
