<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanExpired extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;

        return (new MailMessage)
            ->subject('Tu plan ha expirado - ' . $plan->name)
            ->greeting('Hola ' . $this->purchase->buyer_name)
            ->line('Tu acceso al plan **' . $plan->name . '** ha expirado.')
            ->line('Esperamos que hayas disfrutado de tu experiencia y logrado tus objetivos.')
            ->line('Si deseas continuar tu transformación, puedes renovar tu plan en cualquier momento.')
            ->action('Renovar mi plan', route('public.coach-plan', $plan->slug))
            ->line('¡Gracias por haber sido parte de nuestra comunidad!');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_expired',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'message' => 'Tu plan ' . $this->purchase->coachPlan->name . ' ha expirado.',
        ];
    }
}
