<?php

namespace App\Notifications;

use App\Models\CoachPlanPurchase;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class CoachPlanPurchaseConfirmed extends Notification
{
    use Queueable;

    public function __construct(
        public CoachPlanPurchase $purchase
    ) {}

    public function via($notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail($notifiable): MailMessage
    {
        $plan = $this->purchase->coachPlan;
        $coach = $plan->coach;

        return (new MailMessage)
            ->subject('¡Tu compra ha sido confirmada! - ' . $plan->name)
            ->greeting('¡Hola ' . $this->purchase->buyer_name . '!')
            ->line('Tu pago ha sido verificado y tu acceso al plan está activo.')
            ->line('**Plan:** ' . $plan->name)
            ->line('**Coach:** ' . $coach->name)
            ->line('**Monto pagado:** $' . number_format($this->purchase->amount, 2))
            ->line('**Válido hasta:** ' . $this->purchase->ends_at->format('d/m/Y'))
            ->action('Acceder a mi plan', url('/client/dashboard'))
            ->line('¡Gracias por tu confianza! Tu coach se pondrá en contacto contigo pronto.');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'coach_plan_confirmed',
            'purchase_id' => $this->purchase->id,
            'plan_id' => $this->purchase->coach_plan_id,
            'plan_name' => $this->purchase->coachPlan->name,
            'amount' => $this->purchase->amount,
            'message' => '¡Tu compra del plan ' . $this->purchase->coachPlan->name . ' ha sido confirmada!',
        ];
    }
}
