<?php

namespace App\Notifications;

use App\Models\Setting;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class MealPlanDeleted extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public string $mealPlanName,
        public string $coachName
    ) {}

    public function via(object $notifiable): array
    {
        return ['database', 'mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        $siteName = Setting::get('site_name', 'CoachPro');

        return (new MailMessage)
            ->subject("🗑️ Dieta Eliminada - {$this->mealPlanName}")
            ->greeting("Hola {$notifiable->name},")
            ->line("Tu coach {$this->coachName} ha eliminado tu plan de alimentación.")
            ->line('')
            ->line('**Plan Eliminado:**')
            ->line($this->mealPlanName)
            ->line('')
            ->line('Si necesitas un nuevo plan alimenticio o tienes alguna duda, contacta a tu coach.')
            ->action('Ver Mis Dietas', route('client.meal-plan.index'))
            ->line('Tu coach estará disponible para crear un nuevo plan personalizado cuando lo necesites.')
            ->salutation("Saludos,\nEl equipo de {$siteName}");
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'meal_plan_deleted',
            'meal_plan_name' => $this->mealPlanName,
            'coach_name' => $this->coachName,
            'message' => "🗑️ La dieta '{$this->mealPlanName}' ha sido eliminada por {$this->coachName}",
            'title' => 'Dieta eliminada',
        ];
    }
}
