<?php

namespace App\Notifications;

use App\Models\LandingTestimonial;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TestimonialRejected extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(
        public LandingTestimonial $testimonial,
        public ?string $reason = null
    ) {}

    public function via(object $notifiable): array
    {
        // Database first to ensure in-app notification is saved even if mail fails
        return ['database', 'mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        $mail = (new MailMessage)
            ->subject('Actualización sobre tu testimonio')
            ->greeting("Hola {$notifiable->name},")
            ->line('Gracias por tomarte el tiempo de compartir tu experiencia con CoachPro.')
            ->line('Lamentablemente, en esta ocasión no hemos podido aprobar tu testimonio.');

        if ($this->reason) {
            $mail->line("**Motivo:** {$this->reason}");
        }

        return $mail
            ->line('Te invitamos a enviar un nuevo testimonio que cumpla con nuestras directrices.')
            ->action('Enviar Nuevo Testimonio', route('coach.testimonials.index'))
            ->line('¡Gracias por tu comprensión!');
    }

    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'testimonial_rejected',
            'testimonial_id' => $this->testimonial->id,
            'reason' => $this->reason,
            'message' => 'Tu testimonio no ha sido aprobado.',
        ];
    }
}
