<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('foods', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('cascade'); // null = global food, coach_id = custom food
            $table->string('name');
            $table->string('category')->nullable(); // proteínas, carbohidratos, grasas, frutas, etc.
            $table->decimal('proteins', 6, 2)->default(0); // per 100g
            $table->decimal('carbs', 6, 2)->default(0); // per 100g
            $table->decimal('fats', 6, 2)->default(0); // per 100g
            $table->decimal('calories', 8, 2)->default(0); // per 100g
            $table->decimal('fiber', 6, 2)->default(0); // per 100g
            $table->boolean('is_custom')->default(false);
            $table->timestamps();
            
            $table->index('category');
            $table->index('is_custom');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('foods');
    }
};
