<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Extend the meal_type ENUM to include all meal types
        DB::statement("ALTER TABLE meal_items MODIFY COLUMN meal_type ENUM(
            'breakfast',
            'lunch', 
            'dinner',
            'snack',
            'mid_morning_snack',
            'mid_afternoon_snack',
            'pre_workout',
            'post_workout',
            'intra_workout',
            'meal_1',
            'meal_2',
            'meal_3',
            'desayuno',
            'almuerzo',
            'merienda',
            'merienda_media_manana',
            'merienda_media_tarde',
            'cena',
            'comida_1',
            'comida_2',
            'comida_3',
            'comida_4',
            'comida_5',
            'comida_6',
            'comida_7',
            'comida_8'
        ) NOT NULL DEFAULT 'breakfast'");

        // Add notes column to meal_plans if it doesn't exist
        if (!Schema::hasColumn('meal_plans', 'notes')) {
            Schema::table('meal_plans', function (Blueprint $table) {
                $table->text('notes')->nullable()->after('description');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to original ENUM values
        DB::statement("ALTER TABLE meal_items MODIFY COLUMN meal_type ENUM(
            'breakfast',
            'lunch', 
            'dinner',
            'snack',
            'mid_morning_snack',
            'mid_afternoon_snack',
            'pre_workout',
            'post_workout',
            'meal_1',
            'meal_2',
            'meal_3'
        ) NOT NULL DEFAULT 'breakfast'");

        Schema::table('meal_plans', function (Blueprint $table) {
            $table->dropColumn('notes');
        });
    }
};
