<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('taxes', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Ej: "ITBIS", "IVA", "ISR"
            $table->string('code')->unique(); // Código único: "itbis", "iva", etc.
            $table->decimal('rate', 5, 2); // Porcentaje: 18.00, 16.00, etc.
            $table->text('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->boolean('is_compound')->default(false); // Si se calcula sobre subtotal+otros impuestos
            $table->integer('order')->default(0); // Orden de aplicación
            $table->timestamps();
        });

        // Añadir columna para impuestos en facturas
        Schema::table('invoices', function (Blueprint $table) {
            $table->json('taxes_applied')->nullable()->after('tax'); // Detalle de impuestos aplicados
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn('taxes_applied');
        });

        Schema::dropIfExists('taxes');
    }
};
