<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Only create wallets if not exists
        if (!Schema::hasTable('wallets')) {
            Schema::create('wallets', function (Blueprint $table) {
                $table->id();
                $table->foreignId('user_id')->constrained()->onDelete('cascade');
                $table->decimal('balance', 12, 2)->default(0);
                $table->string('currency', 3)->default('USD');
                $table->timestamps();
                
                $table->unique('user_id');
            });
        }

        // Only create wallet_transactions if not exists
        if (!Schema::hasTable('wallet_transactions')) {
            Schema::create('wallet_transactions', function (Blueprint $table) {
                $table->id();
                $table->foreignId('wallet_id')->constrained()->onDelete('cascade');
                $table->enum('type', ['deposit', 'withdrawal', 'payment', 'referral_bonus', 'adjustment', 'refund']);
                $table->decimal('amount', 12, 2);
                $table->decimal('balance_after', 12, 2)->nullable();
                $table->string('description')->nullable();
                $table->string('reference_type')->nullable();
                $table->unsignedBigInteger('reference_id')->nullable();
                $table->string('payment_method')->nullable();
                $table->string('payment_reference')->nullable();
                $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('pending');
                $table->json('metadata')->nullable();
                $table->timestamps();
                
                $table->index(['wallet_id', 'created_at']);
                $table->index(['type', 'status']);
            });
        } else {
            // Add missing columns to existing wallet_transactions table
            Schema::table('wallet_transactions', function (Blueprint $table) {
                if (!Schema::hasColumn('wallet_transactions', 'balance_after')) {
                    $table->decimal('balance_after', 12, 2)->nullable()->after('amount');
                }
                if (!Schema::hasColumn('wallet_transactions', 'reference_type')) {
                    $table->string('reference_type')->nullable()->after('description');
                }
                if (!Schema::hasColumn('wallet_transactions', 'payment_method')) {
                    $table->string('payment_method')->nullable()->after('reference_id');
                }
                if (!Schema::hasColumn('wallet_transactions', 'payment_reference')) {
                    $table->string('payment_reference')->nullable()->after('payment_method');
                }
                if (!Schema::hasColumn('wallet_transactions', 'metadata')) {
                    $table->json('metadata')->nullable()->after('status');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('wallet_transactions');
        Schema::dropIfExists('wallets');
    }
};
