<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('coach_plan_purchases', function (Blueprint $table) {
            $table->timestamp('expiring_notified_at')->nullable()->after('notes');
            $table->timestamp('expired_notified_at')->nullable()->after('expiring_notified_at');
            $table->timestamp('suspended_at')->nullable()->after('expired_notified_at');
            $table->string('suspension_reason')->nullable()->after('suspended_at');
            $table->boolean('is_recurring')->default(false)->after('suspension_reason');
            $table->string('recurring_period')->nullable()->after('is_recurring'); // monthly, quarterly, yearly
            $table->timestamp('next_payment_due')->nullable()->after('recurring_period');
        });
    }

    public function down(): void
    {
        Schema::table('coach_plan_purchases', function (Blueprint $table) {
            $table->dropColumn([
                'expiring_notified_at',
                'expired_notified_at',
                'suspended_at',
                'suspension_reason',
                'is_recurring',
                'recurring_period',
                'next_payment_due',
            ]);
        });
    }
};
