<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coach_plan_audit_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('coach_plan_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('action'); // created, updated, published, unpublished, deleted
            $table->string('field_changed')->nullable(); // specific field that changed
            $table->text('old_value')->nullable();
            $table->text('new_value')->nullable();
            $table->json('changes_summary')->nullable(); // summary of all changes in one save
            $table->string('ip_address', 45)->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamps();
            
            $table->index(['coach_plan_id', 'created_at']);
            $table->index(['user_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coach_plan_audit_logs');
    }
};
