<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('progress_photos', function (Blueprint $table) {
            $table->boolean('is_public')->default(false);
            $table->string('public_token', 32)->unique()->nullable();
            $table->unsignedInteger('views_count')->default(0);
            $table->unsignedInteger('likes_count')->default(0);
            $table->timestamp('shared_at')->nullable();
            
            $table->index('public_token');
            $table->index(['is_public', 'shared_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('progress_photos', function (Blueprint $table) {
            $table->dropIndex(['progress_photos_public_token_unique']);
            $table->dropIndex(['progress_photos_public_token_index']);
            $table->dropIndex(['progress_photos_is_public_shared_at_index']);
            
            $table->dropColumn([
                'is_public',
                'public_token',
                'views_count',
                'likes_count',
                'shared_at',
            ]);
        });
    }
};
