<?php

namespace Database\Seeders;

use App\Models\Tax;
use Illuminate\Database\Seeder;

class TaxSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $taxes = [
            [
                'name' => 'ITBIS',
                'code' => 'itbis',
                'rate' => 18.00,
                'description' => 'Impuesto sobre Transferencias de Bienes Industrializados y Servicios (República Dominicana)',
                'is_active' => true,
                'is_compound' => false,
                'order' => 1,
            ],
        ];

        foreach ($taxes as $tax) {
            Tax::updateOrCreate(
                ['code' => $tax['code']],
                $tax
            );
        }
    }
}
