<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Factura {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            line-height: 1.6;
            color: #333;
        }
        .header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            border-bottom: 2px solid #3b82f6;
            padding-bottom: 20px;
        }
        .logo {
            font-size: 24px;
            font-weight: bold;
            color: #3b82f6;
        }
        .invoice-info {
            text-align: right;
        }
        .invoice-number {
            font-size: 18px;
            font-weight: bold;
        }
        .section {
            margin-bottom: 20px;
        }
        .section-title {
            font-weight: bold;
            font-size: 14px;
            color: #3b82f6;
            border-bottom: 1px solid #e5e7eb;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border-bottom: 1px solid #e5e7eb;
        }
        th {
            background-color: #f3f4f6;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .totals {
            width: 300px;
            margin-left: auto;
        }
        .totals td {
            padding: 5px 10px;
        }
        .totals .total {
            font-size: 16px;
            font-weight: bold;
            color: #3b82f6;
        }
        .status {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 9999px;
            font-size: 10px;
            font-weight: bold;
            text-transform: uppercase;
        }
        .status-paid {
            background-color: #dcfce7;
            color: #166534;
        }
        .status-pending {
            background-color: #fef3c7;
            color: #92400e;
        }
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #e5e7eb;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <div class="header">
        <div>
</head>
<body>
    <div class="header">
        <div>
            @if(isset($settings['logo']))
                <img src="{{ $settings['logo'] }}" alt="Logo" style="max-height: 50px;">
            @else
                <div class="logo">{{ $settings['header'] }}</div>
            @endif
            <div>Sistema de Gestión para Entrenadores</div>
        </div>
        <div class="invoice-info">
            <div class="invoice-number">{{ $invoice->invoice_number }}</div>
            <div>Fecha: {{ $invoice->created_at->format('d/m/Y') }}</div>
            <div>
                <span class="status status-{{ $invoice->status }}">
                    {{ $invoice->status === 'paid' ? 'Pagado' : ($invoice->status === 'pending' ? 'Pendiente' : 'Cancelado') }}
                </span>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">Datos del Cliente</div>
        <p>
            <strong>{{ $invoice->user->name }}</strong><br>
            {{ $invoice->user->email }}<br>
            @if($invoice->user->phone)
            Tel: {{ $invoice->user->phone }}
            @endif
        </p>
    </div>

    <div class="section">
        <div class="section-title">Detalle de la Factura</div>
        <table>
            <thead>
                <tr>
                    <th>Descripción</th>
                    <th class="text-right">Cantidad</th>
                    <th class="text-right">Precio Unit.</th>
                    <th class="text-right">Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $item)
                <tr>
                    <td>{{ $item['description'] }}</td>
                    <td class="text-right">{{ $item['quantity'] }}</td>
                    <td class="text-right">${{ number_format($item['unit_price'], 2) }}</td>
                    <td class="text-right">${{ number_format($item['total'], 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <table class="totals">
        <tr>
            <td>Subtotal:</td>
            <td class="text-right">${{ number_format($invoice->subtotal, 2) }}</td>
        </tr>
        @if($invoice->taxes_applied && is_array($invoice->taxes_applied) && count($invoice->taxes_applied) > 0)
            @foreach($invoice->taxes_applied as $tax)
            <tr>
                <td>{{ $tax['name'] }}{{ isset($tax['rate']) ? ' (' . $tax['rate'] . '%)' : '' }}:</td>
                <td class="text-right">${{ number_format($tax['amount'], 2) }}</td>
            </tr>
            @endforeach
        @else
        <tr>
            <td>Impuestos:</td>
            <td class="text-right">${{ number_format($invoice->tax, 2) }}</td>
        </tr>
        @endif
        <tr class="total">
            <td><strong>Total:</strong></td>
            <td class="text-right"><strong>${{ number_format($invoice->total, 2) }}</strong></td>
        </tr>
    </table>

    @if($invoice->notes || !empty($settings['note']))
    <div class="section">
        <div class="section-title">Notas</div>
        @if($invoice->notes)<p>{{ $invoice->notes }}</p>@endif
        @if(!empty($settings['note']))<p>{{ $settings['note'] }}</p>@endif
    </div>
    @endif

    <div class="footer">
        <p>{{ $settings['footer'] }}</p>
    </div>
</body>
</html>
