<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Rutina - {{ $client->name }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 11px;
            line-height: 1.5;
            color: #333;
        }
        .header {
            background-color: #f97316;
            color: white;
            padding: 20px;
            margin: -20px -20px 20px -20px;
        }
        .header h1 {
            margin: 0;
            font-size: 22px;
        }
        .header p {
            margin: 5px 0 0 0;
            opacity: 0.9;
        }
        .client-info {
            background-color: #fff7ed;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .client-info h3 {
            margin: 0 0 10px 0;
            color: #ea580c;
        }
        .client-stats {
            display: flex;
            gap: 20px;
        }
        .client-stat {
            text-align: center;
        }
        .client-stat strong {
            display: block;
            font-size: 18px;
            color: #ea580c;
        }
        .days {
            margin-bottom: 20px;
        }
        .day-badge {
            display: inline-block;
            padding: 5px 12px;
            margin: 2px;
            border-radius: 15px;
            font-size: 10px;
            font-weight: bold;
        }
        .day-active {
            background-color: #ea580c;
            color: white;
        }
        .day-inactive {
            background-color: #e5e7eb;
            color: #9ca3af;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th {
            background-color: #f97316;
            color: white;
            padding: 10px;
            text-align: left;
            font-size: 10px;
            text-transform: uppercase;
        }
        td {
            padding: 10px;
            border-bottom: 1px solid #e5e7eb;
        }
        .exercise-name {
            font-weight: bold;
        }
        .muscle-group {
            font-size: 9px;
            color: #6b7280;
        }
        .sets-reps {
            font-size: 14px;
            font-weight: bold;
            color: #ea580c;
        }
        .notes {
            font-size: 10px;
            color: #6b7280;
            font-style: italic;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px solid #f97316;
            text-align: center;
            font-size: 10px;
            color: #6b7280;
        }
        .logo {
            font-size: 16px;
            font-weight: bold;
            color: #f97316;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $workout->name }}</h1>
        <p>{{ $workout->description ?? 'Plan de entrenamiento personalizado' }}</p>
    </div>

    <div class="client-info">
        <h3>{{ $client->name }}</h3>
        <div class="client-stats">
            @if($client->age)<div class="client-stat"><strong>{{ $client->age }}</strong>años</div>@endif
            @if($client->weight)<div class="client-stat"><strong>{{ $client->weight }}kg</strong>peso</div>@endif
            @if($client->height)<div class="client-stat"><strong>{{ $client->height }}cm</strong>altura</div>@endif
            @if($client->objective)<div class="client-stat"><strong>{{ ucfirst($client->objective) }}</strong>objetivo</div>@endif
        </div>
    </div>

    <div class="days">
        <strong>Días de entrenamiento:</strong><br>
        @php
            $allDays = [
                'monday' => 'Lunes',
                'tuesday' => 'Martes',
                'wednesday' => 'Miércoles',
                'thursday' => 'Jueves',
                'friday' => 'Viernes',
                'saturday' => 'Sábado',
                'sunday' => 'Domingo',
            ];
        @endphp
        @foreach($allDays as $key => $label)
            <span class="day-badge {{ in_array($key, $workout->days ?? []) ? 'day-active' : 'day-inactive' }}">
                {{ $label }}
            </span>
        @endforeach
    </div>

    <table>
        <thead>
            <tr>
                <th width="5%">#</th>
                <th width="35%">Ejercicio</th>
                <th width="15%">Series x Reps</th>
                <th width="15%">Descanso</th>
                <th width="30%">Notas</th>
            </tr>
        </thead>
        <tbody>
            @foreach($exercises as $index => $exercise)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>
                    <div class="exercise-name">{{ $exercise->name }}</div>
                    <div class="muscle-group">{{ $exercise->muscle_group }}</div>
                </td>
                <td>
                    <span class="sets-reps">{{ $exercise->sets }}x{{ $exercise->reps }}</span>
                </td>
                <td>{{ $exercise->rest_seconds ? $exercise->rest_seconds . 's' : '-' }}</td>
                <td class="notes">{{ $exercise->notes ?? '-' }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <div class="logo">CoachPro</div>
        <p>Generado el {{ now()->format('d/m/Y') }} | Esta rutina fue creada especialmente para ti</p>
    </div>
</body>
</html>
